<?php
// Directory where uploaded files will be saved
$uploadDir = 'uploads/';
$uploadFile = $uploadDir . basename($_FILES['csvfile']['name']);

// Create the uploads directory if it doesn't exist
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

// Check if the file was uploaded
if (move_uploaded_file($_FILES['csvfile']['tmp_name'], $uploadFile)) {
    echo "File is valid, and was successfully uploaded.\n";

    // Process the uploaded CSV file
    if (($handle = fopen($uploadFile, 'r')) !== false) {
        // Initialize an empty array for the formatted data
        $formattedData = [];

        // Get the header row
        $headers = fgetcsv($handle);

        // Check if headers are retrieved
        if ($headers === false) {
            echo "Failed to read headers.";
            fclose($handle);
            exit;
        }

        // Process each row
        while (($row = fgetcsv($handle)) !== false) {
            // Create an associative array based on the headers
            $data = array_combine($headers, $row);

            // Use the ID as the key
            $id = $data['ID']; // Adjust if the ID column has a different name

            // Add the row data to the formatted array
            $formattedData[$id] = [
                'id' => $data['ID'],
                'name' => $data['Name'],
                'length' => $data['Length'],
                'weight' => $data['Weight'],
                'price' => $data['Price']
            ];
        }

        // Close the file handle
        fclose($handle);

        // Convert the formatted data to JSON
        $json = json_encode($formattedData, JSON_PRETTY_PRINT);

        // Save the JSON output to a file
        $jsonFile = 'output.json';
        file_put_contents($jsonFile, $json);

        echo "CSV file has been converted to JSON with custom format successfully. <br>";
        echo "<a href='$jsonFile'>Download JSON file</a>";
    } else {
        echo "Failed to open the uploaded CSV file.";
    }
} else {
    echo "Possible file upload attack!";
}
